# coding: utf-8

"""
    API ubs_v1 1.0.0

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Measurement(BaseModel):
    """
    Measurement
    """ # noqa: E501
    capacity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Capacity (unit Ah)")
    cell_voltage: Optional[List[StrictInt]] = Field(default=None, description="Array of Cell Voltages (unit mV)")
    current: Union[StrictFloat, StrictInt] = Field(description="Current (unit A)")
    current2: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Second Current (unit A)")
    soc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="State of Charge")
    soh: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="State of Health")
    temperature: Union[StrictFloat, StrictInt] = Field(description="Temperature (unit °C)")
    temperature2: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Second Temperature (unit °C)")
    temperature3: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Third Temperature (unit °C)")
    timestamp: StrictInt = Field(description="Unix timestamp in milliseconds")
    voltage: Union[StrictFloat, StrictInt] = Field(description="Voltage (unit V)")
    __properties: ClassVar[List[str]] = ["capacity", "cell_voltage", "current", "current2", "soc", "soh", "temperature", "temperature2", "temperature3", "timestamp", "voltage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Measurement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Measurement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "capacity": obj.get("capacity"),
            "cell_voltage": obj.get("cell_voltage"),
            "current": obj.get("current"),
            "current2": obj.get("current2"),
            "soc": obj.get("soc"),
            "soh": obj.get("soh"),
            "temperature": obj.get("temperature"),
            "temperature2": obj.get("temperature2"),
            "temperature3": obj.get("temperature3"),
            "timestamp": obj.get("timestamp"),
            "voltage": obj.get("voltage")
        })
        return _obj


