# Measurement


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**capacity** | **float** | Capacity (unit Ah) | [optional] 
**cell_voltage** | **List[int]** | Array of Cell Voltages (unit mV) | [optional] 
**current** | **float** | Current (unit A) | 
**current2** | **float** | Second Current (unit A) | [optional] 
**soc** | **float** | State of Charge | [optional] 
**soh** | **float** | State of Health | [optional] 
**temperature** | **float** | Temperature (unit °C) | 
**temperature2** | **float** | Second Temperature (unit °C) | [optional] 
**temperature3** | **float** | Third Temperature (unit °C) | [optional] 
**timestamp** | **int** | Unix timestamp in milliseconds | 
**voltage** | **float** | Voltage (unit V) | 

## Example

```python
from openapi_client.models.measurement import Measurement

# TODO update the JSON string below
json = "{}"
# create an instance of Measurement from a JSON string
measurement_instance = Measurement.from_json(json)
# print the JSON string representation of the object
print(Measurement.to_json())

# convert the object into a dict
measurement_dict = measurement_instance.to_dict()
# create an instance of Measurement from a dict
measurement_from_dict = Measurement.from_dict(measurement_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


