# openapi_client.DefaultApi

All URIs are relative to *https://data.movemore.hs-offenburg.de/api/ubs/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**health_get**](DefaultApi.md#health_get) | **GET** /health | 
[**model_get**](DefaultApi.md#model_get) | **GET** /model | 
[**model_id_delete**](DefaultApi.md#model_id_delete) | **DELETE** /model/{id} | 
[**model_id_get**](DefaultApi.md#model_id_get) | **GET** /model/{id} | 
[**model_id_values_get**](DefaultApi.md#model_id_values_get) | **GET** /model/{id}/values | 
[**model_id_values_put**](DefaultApi.md#model_id_values_put) | **PUT** /model/{id}/values | 
[**model_list_get**](DefaultApi.md#model_list_get) | **GET** /model_list | 
[**model_put**](DefaultApi.md#model_put) | **PUT** /model | 


# **health_get**
> str health_get()

Test if server is responsive.

### Example


```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)

    try:
        api_response = api_instance.health_get()
        print("The response of DefaultApi->health_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->health_get: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: text/plain

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Server healthy |  -  |
**404** | Server not healty |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_get**
> Model model_get(name=name)

Get Model by field value

### Example


```python
import openapi_client
from openapi_client.models.model import Model
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    name = 'name_example' # str |  (optional)

    try:
        api_response = api_instance.model_get(name=name)
        print("The response of DefaultApi->model_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->model_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **str**|  | [optional] 

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Model retrieved |  -  |
**404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_id_delete**
> model_id_delete(id)

Delete Model by database id

### Example


```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    id = 56 # int | 

    try:
        api_instance.model_id_delete(id)
    except Exception as e:
        print("Exception when calling DefaultApi->model_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Model deleted |  -  |
**404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_id_get**
> Model model_id_get(id)

Get Model by database id

### Example


```python
import openapi_client
from openapi_client.models.model import Model
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    id = 56 # int | 

    try:
        api_response = api_instance.model_id_get(id)
        print("The response of DefaultApi->model_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->model_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  | 

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Model retrieved |  -  |
**404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_id_values_get**
> List[Measurement] model_id_values_get(id)

Get list of Measurement from Model by database id

### Example


```python
import openapi_client
from openapi_client.models.measurement import Measurement
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    id = 56 # int | 

    try:
        api_response = api_instance.model_id_values_get(id)
        print("The response of DefaultApi->model_id_values_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->model_id_values_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  | 

### Return type

[**List[Measurement]**](Measurement.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of Measurement retrieved |  -  |
**404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_id_values_put**
> model_id_values_put(id, measurement=measurement)

Add list of Measurement to Model by database id

### Example


```python
import openapi_client
from openapi_client.models.measurement import Measurement
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    id = 56 # int | 
    measurement = [openapi_client.Measurement()] # List[Measurement] |  (optional)

    try:
        api_instance.model_id_values_put(id, measurement=measurement)
    except Exception as e:
        print("Exception when calling DefaultApi->model_id_values_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  | 
 **measurement** | [**List[Measurement]**](Measurement.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Model updated |  -  |
**404** | Model does not exist |  -  |
**422** | Model is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_list_get**
> List[Model] model_list_get()

Get list of all Model

### Example


```python
import openapi_client
from openapi_client.models.model import Model
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)

    try:
        api_response = api_instance.model_list_get()
        print("The response of DefaultApi->model_list_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->model_list_get: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[Model]**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of Model retrieved |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **model_put**
> Model model_put(model=model)

Create or or update Model

If the object id is zero, the object is inserted and the new id is filled into the returned object.

If the object id is non-zero, the object is updated and returned.


### Example


```python
import openapi_client
from openapi_client.models.model import Model
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://data.movemore.hs-offenburg.de/api/ubs/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://data.movemore.hs-offenburg.de/api/ubs/v1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    model = openapi_client.Model() # Model |  (optional)

    try:
        api_response = api_instance.model_put(model=model)
        print("The response of DefaultApi->model_put:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultApi->model_put: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **model** | [**Model**](Model.md)|  | [optional] 

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Model updated |  -  |
**201** | Model created |  -  |
**422** | Model is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

