// <auto-generated>
/*
 * API ubs_v1 1.0.0
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

#nullable enable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.ComponentModel.DataAnnotations;
using Org.OpenAPITools.Client;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// Measurement
    /// </summary>
    public partial class Measurement : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Measurement" /> class.
        /// </summary>
        /// <param name="current">Current (unit A)</param>
        /// <param name="temperature">Temperature (unit °C)</param>
        /// <param name="timestamp">Unix timestamp in milliseconds</param>
        /// <param name="voltage">Voltage (unit V)</param>
        /// <param name="capacity">Capacity (unit Ah)</param>
        /// <param name="cellVoltage">Array of Cell Voltages (unit mV)</param>
        /// <param name="current2">Second Current (unit A)</param>
        /// <param name="soc">State of Charge</param>
        /// <param name="soh">State of Health</param>
        /// <param name="temperature2">Second Temperature (unit °C)</param>
        /// <param name="temperature3">Third Temperature (unit °C)</param>
        [JsonConstructor]
        public Measurement(float current, float temperature, long timestamp, float voltage, Option<float?> capacity = default, Option<List<int>?> cellVoltage = default, Option<float?> current2 = default, Option<float?> soc = default, Option<float?> soh = default, Option<float?> temperature2 = default, Option<float?> temperature3 = default)
        {
            Current = current;
            Temperature = temperature;
            Timestamp = timestamp;
            Voltage = voltage;
            CapacityOption = capacity;
            CellVoltageOption = cellVoltage;
            Current2Option = current2;
            SocOption = soc;
            SohOption = soh;
            Temperature2Option = temperature2;
            Temperature3Option = temperature3;
            OnCreated();
        }

        partial void OnCreated();

        /// <summary>
        /// Current (unit A)
        /// </summary>
        /// <value>Current (unit A)</value>
        [JsonPropertyName("current")]
        public float Current { get; set; }

        /// <summary>
        /// Temperature (unit °C)
        /// </summary>
        /// <value>Temperature (unit °C)</value>
        [JsonPropertyName("temperature")]
        public float Temperature { get; set; }

        /// <summary>
        /// Unix timestamp in milliseconds
        /// </summary>
        /// <value>Unix timestamp in milliseconds</value>
        [JsonPropertyName("timestamp")]
        public long Timestamp { get; set; }

        /// <summary>
        /// Voltage (unit V)
        /// </summary>
        /// <value>Voltage (unit V)</value>
        [JsonPropertyName("voltage")]
        public float Voltage { get; set; }

        /// <summary>
        /// Used to track the state of Capacity
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> CapacityOption { get; private set; }

        /// <summary>
        /// Capacity (unit Ah)
        /// </summary>
        /// <value>Capacity (unit Ah)</value>
        [JsonPropertyName("capacity")]
        public float? Capacity { get { return this.CapacityOption; } set { this.CapacityOption = new(value); } }

        /// <summary>
        /// Used to track the state of CellVoltage
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<List<int>?> CellVoltageOption { get; private set; }

        /// <summary>
        /// Array of Cell Voltages (unit mV)
        /// </summary>
        /// <value>Array of Cell Voltages (unit mV)</value>
        [JsonPropertyName("cell_voltage")]
        public List<int>? CellVoltage { get { return this.CellVoltageOption; } set { this.CellVoltageOption = new(value); } }

        /// <summary>
        /// Used to track the state of Current2
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> Current2Option { get; private set; }

        /// <summary>
        /// Second Current (unit A)
        /// </summary>
        /// <value>Second Current (unit A)</value>
        [JsonPropertyName("current2")]
        public float? Current2 { get { return this.Current2Option; } set { this.Current2Option = new(value); } }

        /// <summary>
        /// Used to track the state of Soc
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> SocOption { get; private set; }

        /// <summary>
        /// State of Charge
        /// </summary>
        /// <value>State of Charge</value>
        [JsonPropertyName("soc")]
        public float? Soc { get { return this.SocOption; } set { this.SocOption = new(value); } }

        /// <summary>
        /// Used to track the state of Soh
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> SohOption { get; private set; }

        /// <summary>
        /// State of Health
        /// </summary>
        /// <value>State of Health</value>
        [JsonPropertyName("soh")]
        public float? Soh { get { return this.SohOption; } set { this.SohOption = new(value); } }

        /// <summary>
        /// Used to track the state of Temperature2
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> Temperature2Option { get; private set; }

        /// <summary>
        /// Second Temperature (unit °C)
        /// </summary>
        /// <value>Second Temperature (unit °C)</value>
        [JsonPropertyName("temperature2")]
        public float? Temperature2 { get { return this.Temperature2Option; } set { this.Temperature2Option = new(value); } }

        /// <summary>
        /// Used to track the state of Temperature3
        /// </summary>
        [JsonIgnore]
        [global::System.ComponentModel.EditorBrowsable(global::System.ComponentModel.EditorBrowsableState.Never)]
        public Option<float?> Temperature3Option { get; private set; }

        /// <summary>
        /// Third Temperature (unit °C)
        /// </summary>
        /// <value>Third Temperature (unit °C)</value>
        [JsonPropertyName("temperature3")]
        public float? Temperature3 { get { return this.Temperature3Option; } set { this.Temperature3Option = new(value); } }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Measurement {\n");
            sb.Append("  Current: ").Append(Current).Append("\n");
            sb.Append("  Temperature: ").Append(Temperature).Append("\n");
            sb.Append("  Timestamp: ").Append(Timestamp).Append("\n");
            sb.Append("  Voltage: ").Append(Voltage).Append("\n");
            sb.Append("  Capacity: ").Append(Capacity).Append("\n");
            sb.Append("  CellVoltage: ").Append(CellVoltage).Append("\n");
            sb.Append("  Current2: ").Append(Current2).Append("\n");
            sb.Append("  Soc: ").Append(Soc).Append("\n");
            sb.Append("  Soh: ").Append(Soh).Append("\n");
            sb.Append("  Temperature2: ").Append(Temperature2).Append("\n");
            sb.Append("  Temperature3: ").Append(Temperature3).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

    /// <summary>
    /// A Json converter for type <see cref="Measurement" />
    /// </summary>
    public class MeasurementJsonConverter : JsonConverter<Measurement>
    {
        /// <summary>
        /// Deserializes json to <see cref="Measurement" />
        /// </summary>
        /// <param name="utf8JsonReader"></param>
        /// <param name="typeToConvert"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <returns></returns>
        /// <exception cref="JsonException"></exception>
        public override Measurement Read(ref Utf8JsonReader utf8JsonReader, Type typeToConvert, JsonSerializerOptions jsonSerializerOptions)
        {
            int currentDepth = utf8JsonReader.CurrentDepth;

            if (utf8JsonReader.TokenType != JsonTokenType.StartObject && utf8JsonReader.TokenType != JsonTokenType.StartArray)
                throw new JsonException();

            JsonTokenType startingTokenType = utf8JsonReader.TokenType;

            Option<float?> current = default;
            Option<float?> temperature = default;
            Option<long?> timestamp = default;
            Option<float?> voltage = default;
            Option<float?> capacity = default;
            Option<List<int>?> cellVoltage = default;
            Option<float?> current2 = default;
            Option<float?> soc = default;
            Option<float?> soh = default;
            Option<float?> temperature2 = default;
            Option<float?> temperature3 = default;

            while (utf8JsonReader.Read())
            {
                if (startingTokenType == JsonTokenType.StartObject && utf8JsonReader.TokenType == JsonTokenType.EndObject && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (startingTokenType == JsonTokenType.StartArray && utf8JsonReader.TokenType == JsonTokenType.EndArray && currentDepth == utf8JsonReader.CurrentDepth)
                    break;

                if (utf8JsonReader.TokenType == JsonTokenType.PropertyName && currentDepth == utf8JsonReader.CurrentDepth - 1)
                {
                    string? localVarJsonPropertyName = utf8JsonReader.GetString();
                    utf8JsonReader.Read();

                    switch (localVarJsonPropertyName)
                    {
                        case "current":
                            current = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "temperature":
                            temperature = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "timestamp":
                            timestamp = new Option<long?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (long?)null : utf8JsonReader.GetInt64());
                            break;
                        case "voltage":
                            voltage = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "capacity":
                            capacity = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "cell_voltage":
                            cellVoltage = new Option<List<int>?>(JsonSerializer.Deserialize<List<int>>(ref utf8JsonReader, jsonSerializerOptions)!);
                            break;
                        case "current2":
                            current2 = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "soc":
                            soc = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "soh":
                            soh = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "temperature2":
                            temperature2 = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        case "temperature3":
                            temperature3 = new Option<float?>(utf8JsonReader.TokenType == JsonTokenType.Null ? (float?)null : (float)utf8JsonReader.GetDouble());
                            break;
                        default:
                            break;
                    }
                }
            }

            if (!current.IsSet)
                throw new ArgumentException("Property is required for class Measurement.", nameof(current));

            if (!temperature.IsSet)
                throw new ArgumentException("Property is required for class Measurement.", nameof(temperature));

            if (!timestamp.IsSet)
                throw new ArgumentException("Property is required for class Measurement.", nameof(timestamp));

            if (!voltage.IsSet)
                throw new ArgumentException("Property is required for class Measurement.", nameof(voltage));

            if (current.IsSet && current.Value == null)
                throw new ArgumentNullException(nameof(current), "Property is not nullable for class Measurement.");

            if (temperature.IsSet && temperature.Value == null)
                throw new ArgumentNullException(nameof(temperature), "Property is not nullable for class Measurement.");

            if (timestamp.IsSet && timestamp.Value == null)
                throw new ArgumentNullException(nameof(timestamp), "Property is not nullable for class Measurement.");

            if (voltage.IsSet && voltage.Value == null)
                throw new ArgumentNullException(nameof(voltage), "Property is not nullable for class Measurement.");

            if (capacity.IsSet && capacity.Value == null)
                throw new ArgumentNullException(nameof(capacity), "Property is not nullable for class Measurement.");

            if (cellVoltage.IsSet && cellVoltage.Value == null)
                throw new ArgumentNullException(nameof(cellVoltage), "Property is not nullable for class Measurement.");

            if (current2.IsSet && current2.Value == null)
                throw new ArgumentNullException(nameof(current2), "Property is not nullable for class Measurement.");

            if (soc.IsSet && soc.Value == null)
                throw new ArgumentNullException(nameof(soc), "Property is not nullable for class Measurement.");

            if (soh.IsSet && soh.Value == null)
                throw new ArgumentNullException(nameof(soh), "Property is not nullable for class Measurement.");

            if (temperature2.IsSet && temperature2.Value == null)
                throw new ArgumentNullException(nameof(temperature2), "Property is not nullable for class Measurement.");

            if (temperature3.IsSet && temperature3.Value == null)
                throw new ArgumentNullException(nameof(temperature3), "Property is not nullable for class Measurement.");

            return new Measurement(current.Value!.Value!, temperature.Value!.Value!, timestamp.Value!.Value!, voltage.Value!.Value!, capacity, cellVoltage, current2, soc, soh, temperature2, temperature3);
        }

        /// <summary>
        /// Serializes a <see cref="Measurement" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="measurement"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public override void Write(Utf8JsonWriter writer, Measurement measurement, JsonSerializerOptions jsonSerializerOptions)
        {
            writer.WriteStartObject();

            WriteProperties(writer, measurement, jsonSerializerOptions);
            writer.WriteEndObject();
        }

        /// <summary>
        /// Serializes the properties of <see cref="Measurement" />
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="measurement"></param>
        /// <param name="jsonSerializerOptions"></param>
        /// <exception cref="NotImplementedException"></exception>
        public void WriteProperties(Utf8JsonWriter writer, Measurement measurement, JsonSerializerOptions jsonSerializerOptions)
        {
            if (measurement.CellVoltageOption.IsSet && measurement.CellVoltage == null)
                throw new ArgumentNullException(nameof(measurement.CellVoltage), "Property is required for class Measurement.");

            writer.WriteNumber("current", measurement.Current);

            writer.WriteNumber("temperature", measurement.Temperature);

            writer.WriteNumber("timestamp", measurement.Timestamp);

            writer.WriteNumber("voltage", measurement.Voltage);

            if (measurement.CapacityOption.IsSet)
                writer.WriteNumber("capacity", measurement.CapacityOption.Value!.Value);

            if (measurement.CellVoltageOption.IsSet)
            {
                writer.WritePropertyName("cell_voltage");
                JsonSerializer.Serialize(writer, measurement.CellVoltage, jsonSerializerOptions);
            }
            if (measurement.Current2Option.IsSet)
                writer.WriteNumber("current2", measurement.Current2Option.Value!.Value);

            if (measurement.SocOption.IsSet)
                writer.WriteNumber("soc", measurement.SocOption.Value!.Value);

            if (measurement.SohOption.IsSet)
                writer.WriteNumber("soh", measurement.SohOption.Value!.Value);

            if (measurement.Temperature2Option.IsSet)
                writer.WriteNumber("temperature2", measurement.Temperature2Option.Value!.Value);

            if (measurement.Temperature3Option.IsSet)
                writer.WriteNumber("temperature3", measurement.Temperature3Option.Value!.Value);
        }
    }
}
