# Org.OpenAPITools.Api.DefaultApi

All URIs are relative to *https://data.movemore.hs-offenburg.de/api/ubs/v1*

| Method | HTTP request | Description |
|--------|--------------|-------------|
| [**HealthGet**](DefaultApi.md#healthget) | **GET** /health |  |
| [**ModelGet**](DefaultApi.md#modelget) | **GET** /model |  |
| [**ModelIdDelete**](DefaultApi.md#modeliddelete) | **DELETE** /model/{id} |  |
| [**ModelIdGet**](DefaultApi.md#modelidget) | **GET** /model/{id} |  |
| [**ModelIdValuesGet**](DefaultApi.md#modelidvaluesget) | **GET** /model/{id}/values |  |
| [**ModelIdValuesPut**](DefaultApi.md#modelidvaluesput) | **PUT** /model/{id}/values |  |
| [**ModelListGet**](DefaultApi.md#modellistget) | **GET** /model_list |  |
| [**ModelPut**](DefaultApi.md#modelput) | **PUT** /model |  |

<a id="healthget"></a>
# **HealthGet**
> string HealthGet ()



Test if server is responsive.


### Parameters
This endpoint does not need any parameter.
### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Server healthy |  -  |
| **404** | Server not healty |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modelget"></a>
# **ModelGet**
> Model ModelGet (string name = null)



Get Model by field value


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **name** | **string** |  | [optional]  |

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Model retrieved |  -  |
| **404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modeliddelete"></a>
# **ModelIdDelete**
> void ModelIdDelete (int id)



Delete Model by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Model deleted |  -  |
| **404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modelidget"></a>
# **ModelIdGet**
> Model ModelIdGet (int id)



Get Model by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Model retrieved |  -  |
| **404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modelidvaluesget"></a>
# **ModelIdValuesGet**
> List&lt;Measurement&gt; ModelIdValuesGet (int id)



Get list of Measurement from Model by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

[**List&lt;Measurement&gt;**](Measurement.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of Measurement retrieved |  -  |
| **404** | Model does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modelidvaluesput"></a>
# **ModelIdValuesPut**
> void ModelIdValuesPut (int id, List<Measurement> measurement = null)



Add list of Measurement to Model by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |
| **measurement** | [**List&lt;Measurement&gt;**](Measurement.md) |  | [optional]  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Model updated |  -  |
| **404** | Model does not exist |  -  |
| **422** | Model is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modellistget"></a>
# **ModelListGet**
> List&lt;Model&gt; ModelListGet ()



Get list of all Model


### Parameters
This endpoint does not need any parameter.
### Return type

[**List&lt;Model&gt;**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of Model retrieved |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="modelput"></a>
# **ModelPut**
> Model ModelPut (Model model = null)



Create or or update Model  If the object id is zero, the object is inserted and the new id is filled into the returned object.  If the object id is non-zero, the object is updated and returned. 


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **model** | [**Model**](Model.md) |  | [optional]  |

### Return type

[**Model**](Model.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Model updated |  -  |
| **201** | Model created |  -  |
| **422** | Model is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

