# Org.OpenAPITools.Api.DefaultApi

All URIs are relative to *https://data.movemore.hs-offenburg.de/api/ebike/v1*

| Method | HTTP request | Description |
|--------|--------------|-------------|
| [**EbikeIdDelete**](DefaultApi.md#ebikeiddelete) | **DELETE** /ebike/{id} |  |
| [**EbikeIdGet**](DefaultApi.md#ebikeidget) | **GET** /ebike/{id} |  |
| [**EbikeListGet**](DefaultApi.md#ebikelistget) | **GET** /ebike_list |  |
| [**EbikePut**](DefaultApi.md#ebikeput) | **PUT** /ebike |  |
| [**HealthGet**](DefaultApi.md#healthget) | **GET** /health |  |
| [**RiderIdDelete**](DefaultApi.md#rideriddelete) | **DELETE** /rider/{id} |  |
| [**RiderIdGet**](DefaultApi.md#rideridget) | **GET** /rider/{id} |  |
| [**RiderListGet**](DefaultApi.md#riderlistget) | **GET** /rider_list |  |
| [**RiderPut**](DefaultApi.md#riderput) | **PUT** /rider |  |
| [**RouteIdDelete**](DefaultApi.md#routeiddelete) | **DELETE** /route/{id} |  |
| [**RouteIdGet**](DefaultApi.md#routeidget) | **GET** /route/{id} |  |
| [**RouteListGet**](DefaultApi.md#routelistget) | **GET** /route_list |  |
| [**RoutePut**](DefaultApi.md#routeput) | **PUT** /route |  |

<a id="ebikeiddelete"></a>
# **EbikeIdDelete**
> void EbikeIdDelete (int id)



Delete Ebike by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Ebike deleted |  -  |
| **404** | Ebike does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="ebikeidget"></a>
# **EbikeIdGet**
> Ebike EbikeIdGet (int id)



Get Ebike by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

[**Ebike**](Ebike.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Ebike retrieved |  -  |
| **404** | Ebike does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="ebikelistget"></a>
# **EbikeListGet**
> List&lt;Ebike&gt; EbikeListGet ()



Get list of all Ebike


### Parameters
This endpoint does not need any parameter.
### Return type

[**List&lt;Ebike&gt;**](Ebike.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of Ebike retrieved |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="ebikeput"></a>
# **EbikePut**
> Ebike EbikePut (Ebike ebike = null)



Create or or update Ebike  If the object id is zero, the object is inserted and the new id is filled into the returned object.  If the object id is non-zero, the object is updated and returned. 


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **ebike** | [**Ebike**](Ebike.md) |  | [optional]  |

### Return type

[**Ebike**](Ebike.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Ebike updated |  -  |
| **201** | Ebike created |  -  |
| **422** | Ebike is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="healthget"></a>
# **HealthGet**
> string HealthGet ()



Test if server is responsive.


### Parameters
This endpoint does not need any parameter.
### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Server healthy |  -  |
| **404** | Server not healty |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="rideriddelete"></a>
# **RiderIdDelete**
> void RiderIdDelete (int id)



Delete Rider by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Rider deleted |  -  |
| **404** | Rider does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="rideridget"></a>
# **RiderIdGet**
> Rider RiderIdGet (int id)



Get Rider by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

[**Rider**](Rider.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Rider retrieved |  -  |
| **404** | Rider does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="riderlistget"></a>
# **RiderListGet**
> List&lt;Rider&gt; RiderListGet ()



Get list of all Rider


### Parameters
This endpoint does not need any parameter.
### Return type

[**List&lt;Rider&gt;**](Rider.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of Rider retrieved |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="riderput"></a>
# **RiderPut**
> Rider RiderPut (Rider rider = null)



Create or or update Rider  If the object id is zero, the object is inserted and the new id is filled into the returned object.  If the object id is non-zero, the object is updated and returned. 


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **rider** | [**Rider**](Rider.md) |  | [optional]  |

### Return type

[**Rider**](Rider.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Rider updated |  -  |
| **201** | Rider created |  -  |
| **422** | Rider is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="routeiddelete"></a>
# **RouteIdDelete**
> void RouteIdDelete (int id)



Delete Route by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Route deleted |  -  |
| **404** | Route does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="routeidget"></a>
# **RouteIdGet**
> Route RouteIdGet (int id)



Get Route by database id


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **id** | **int** |  |  |

### Return type

[**Route**](Route.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Route retrieved |  -  |
| **404** | Route does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="routelistget"></a>
# **RouteListGet**
> List&lt;Route&gt; RouteListGet ()



Get list of all Route


### Parameters
This endpoint does not need any parameter.
### Return type

[**List&lt;Route&gt;**](Route.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of Route retrieved |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

<a id="routeput"></a>
# **RoutePut**
> Route RoutePut (Route route = null)



Create or or update Route  If the object id is zero, the object is inserted and the new id is filled into the returned object.  If the object id is non-zero, the object is updated and returned. 


### Parameters

| Name | Type | Description | Notes |
|------|------|-------------|-------|
| **route** | [**Route**](Route.md) |  | [optional]  |

### Return type

[**Route**](Route.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Route updated |  -  |
| **201** | Route created |  -  |
| **422** | Route is invalid |  -  |

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

